<{* Publisher Slider/Carousel Template - Kaydırmalı Görünüm *}>

<{if $publisher_count > 0}>
    <div class="publisher-slider">
        <div class="slider-wrapper">
            <div class="slider-track" id="sliderTrack">
                <{foreach item=slide from=$publisher_items}>
                    <div class="slide-item">
                        <{if $slide.image}>
                            <div class="slide-image">
                                <img src="<{$slide.image}>" alt="<{$slide.title}>" />
                                <div class="slide-overlay"></div>
                            </div>
                        <{/if}>
                        
                        <div class="slide-content">
                            <div class="slide-category">
                                <a href="<{$slide.category_link}>">Kategori</a>
                            </div>
                            
                            <h2 class="slide-title">
                                <a href="<{$slide.link}>"><{$slide.title}></a>
                            </h2>
                            
                            <{if $slide.subtitle}>
                                <p class="slide-subtitle"><{$slide.subtitle}></p>
                            <{/if}>
                            
                            <div class="slide-meta">
                                <{if $slide.votes > 0}>
                                    <div class="slide-rating">
                                        <span class="stars">
                                            <{assign var="fullStars" value=$slide.rating|floor}>
                                            <{section name=star loop=5}>
                                                <{if $smarty.section.star.index < $fullStars}>★<{else}>☆<{/if}>
                                            <{/section}>
                                        </span>
                                        <span class="rating-num"><{$slide.rating}>/5</span>
                                    </div>
                                <{/if}>
                                
                                <div class="slide-stats">
                                    <span><i class="fa fa-eye"></i> <{$slide.counter}></span>
                                    <span><i class="fa fa-calendar"></i> <{$slide.date_short}></span>
                                </div>
                            </div>
                            
                            <div class="slide-actions">
                                <a href="<{$slide.link}>" class="btn-detail">Detaylar</a>
                            </div>
                        </div>
                    </div>
                <{/foreach}>
            </div>
        </div>
        
        <{if $publisher_count > 1}>
            <button class="slider-nav prev" onclick="slideMove(-1)">
                <i class="fa fa-chevron-left"></i>
            </button>
            <button class="slider-nav next" onclick="slideMove(1)">
                <i class="fa fa-chevron-right"></i>
            </button>
            
            <div class="slider-dots" id="sliderDots"></div>
        <{/if}>
    </div>
<{/if}>

<style>
.publisher-slider {
    position: relative;
    width: 100%;
    max-width: 1200px;
    margin: 0 auto;
    overflow: hidden;
    border-radius: 10px;
}

.slider-wrapper {
    width: 100%;
    overflow: hidden;
}

.slider-track {
    display: flex;
    transition: transform 0.5s ease-in-out;
}

.slide-item {
    min-width: 100%;
    position: relative;
    height: 500px;
    display: flex;
    align-items: center;
}

.slide-image {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 1;
}

.slide-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.slide-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: linear-gradient(to right, rgba(0,0,0,0.7) 0%, rgba(0,0,0,0.3) 100%);
}

.slide-content {
    position: relative;
    z-index: 2;
    color: #fff;
    padding: 40px 60px;
    max-width: 600px;
}

.slide-category {
    margin-bottom: 15px;
}

.slide-category a {
    display: inline-block;
    padding: 5px 15px;
    background: rgba(255,255,255,0.2);
    color: #fff;
    text-decoration: none;
    border-radius: 20px;
    font-size: 12px;
    text-transform: uppercase;
    letter-spacing: 1px;
    backdrop-filter: blur(10px);
}

.slide-title {
    margin: 0 0 15px 0;
    font-size: 42px;
    font-weight: 700;
    line-height: 1.2;
    text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
}

.slide-title a {
    color: #fff;
    text-decoration: none;
}

.slide-subtitle {
    font-size: 18px;
    margin-bottom: 20px;
    opacity: 0.9;
    line-height: 1.6;
}

.slide-meta {
    margin-bottom: 25px;
}

.slide-rating {
    margin-bottom: 10px;
}

.slide-rating .stars {
    color: #ffd700;
    font-size: 20px;
    margin-right: 8px;
}

.slide-rating .rating-num {
    font-weight: 600;
    font-size: 16px;
}

.slide-stats {
    display: flex;
    gap: 20px;
    opacity: 0.9;
}

.slide-stats span {
    font-size: 14px;
}

.slide-stats i {
    margin-right: 5px;
}

.slide-actions .btn-detail {
    display: inline-block;
    padding: 15px 40px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: #fff;
    text-decoration: none;
    border-radius: 30px;
    font-weight: 600;
    font-size: 16px;
    transition: all 0.3s ease;
    box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
}

.slide-actions .btn-detail:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.6);
}

.slider-nav {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    background: rgba(255,255,255,0.3);
    border: none;
    color: #fff;
    width: 50px;
    height: 50px;
    border-radius: 50%;
    cursor: pointer;
    transition: all 0.3s ease;
    z-index: 3;
    backdrop-filter: blur(10px);
}

.slider-nav:hover {
    background: rgba(255,255,255,0.5);
    transform: translateY(-50%) scale(1.1);
}

.slider-nav.prev {
    left: 20px;
}

.slider-nav.next {
    right: 20px;
}

.slider-dots {
    position: absolute;
    bottom: 20px;
    left: 50%;
    transform: translateX(-50%);
    display: flex;
    gap: 10px;
    z-index: 3;
}

.dot {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    background: rgba(255,255,255,0.5);
    cursor: pointer;
    transition: all 0.3s ease;
}

.dot.active {
    background: #fff;
    width: 30px;
    border-radius: 6px;
}

/* Responsive Design */
@media (max-width: 768px) {
    .slide-item {
        height: 400px;
    }
    
    .slide-content {
        padding: 30px;
    }
    
    .slide-title {
        font-size: 28px;
    }
    
    .slide-subtitle {
        font-size: 14px;
    }
    
    .slider-nav {
        width: 40px;
        height: 40px;
    }
}

@media (max-width: 480px) {
    .slide-item {
        height: 350px;
    }
    
    .slide-content {
        padding: 20px;
    }
    
    .slide-title {
        font-size: 22px;
    }
    
    .slide-actions .btn-detail {
        padding: 12px 30px;
        font-size: 14px;
    }
}
</style>

<script>
let currentSlide = 0;
const slides = document.querySelectorAll('.slide-item');
const totalSlides = slides.length;
const dotsContainer = document.getElementById('sliderDots');

// Dots oluştur
for (let i = 0; i < totalSlides; i++) {
    const dot = document.createElement('span');
    dot.className = 'dot';
    if (i === 0) dot.classList.add('active');
    dot.onclick = () => goToSlide(i);
    dotsContainer.appendChild(dot);
}

function slideMove(direction) {
    currentSlide += direction;
    
    if (currentSlide < 0) {
        currentSlide = totalSlides - 1;
    } else if (currentSlide >= totalSlides) {
        currentSlide = 0;
    }
    
    updateSlider();
}

function goToSlide(index) {
    currentSlide = index;
    updateSlider();
}

function updateSlider() {
    const track = document.getElementById('sliderTrack');
    track.style.transform = `translateX(-${currentSlide * 100}%)`;
    
    // Dots güncelle
    document.querySelectorAll('.dot').forEach((dot, index) => {
        dot.classList.toggle('active', index === currentSlide);
    });
}

// Otomatik kaydırma (5 saniyede bir)
if (totalSlides > 1) {
    setInterval(() => {
        slideMove(1);
    }, 5000);
}
</script>
